#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;
#else
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform float fade;

void main()
{
#ifdef GL_ES
    vec4 color = texture2D(colorTex, vTexCoord.st);
    gl_FragColor = vec4((color.rgb + fade) * color.a, color.a);
#else
    vec4 color = texture(colorTex, vTexCoord.st);
    fragColor = vec4((color.rgb + fade) * color.a, color.a);
#endif
}
